function ribbonplot(x,y,e)
% RIBBONPLOT(X,Y,E)
% Makes an alternative mean +- error plot, like a ribbon.

% Jan 8 2015: Created.

if(nargin<3)
    x = [1 2 3 4];
    y = [1 2 3 2];
    e = [1 2 1 1.4]/5;
    figure;
end

x = x(:); y = y(:); e = e(:);

switch 2
    case 0
        xx = x; yy = y; ee = e;
    case 1
        xx = linspace(min(x),max(x),100);
        yy = spline(x,y,xx);
        ee = spline(x,e,xx);
        xx = xx(:); yy = yy(:); ee = ee(:);
    case 2        
        xx = linspace(min(x),max(x),100);
        F = griddedInterpolant(x,y,'pchip');    % Shape-preserving piecewise cubic interpolation 
        yy = F(xx);
        F = griddedInterpolant(x,e,'pchip');
        ee = F(xx);
        xx = xx(:); yy = yy(:); ee = ee(:);
end

np = get(gca,'NextPlot');
hold on;
h = area(xx,[yy-ee 2*ee]);
set(h(1),'FaceColor','none','EdgeColor','none');
set(h(2),'FaceColor',[8 8 9]/9,'EdgeColor','none');
plot(xx,yy,'k-');
plot(x,y,'k.');

for(q=1:length(x))
    plot([x(q) x(q)],[-1 1]*e(q)+y(q),'b-');
end

hold off;
set(gca,'NextPlot',np);

end